;-------------------------------------------------------------------------------------------------------------
;Converted to AutoIT by Andrew Calcutt - http://www.techidiots.net/autoit-scripts/circle%20generator.au3/view - 5/29/2007
;Based of the source code avalible here http://dev.bt23.org/keyhole/circlegen/output.phps - http://dev.bt23.org/keyhole/circlegen/
;-------------------------------------------------------------------------------------------------------------
#include <GuiConstants.au3>

;declair variables
Dim $PI = 4 * ATan(1)
Dim $viewdistance = 500
Dim $defaultfilename = @MON & '-' & @MDAY & '-' & @YEAR & '_' & @HOUR & '-' & @MIN & '-' & @SEC & '.kml'
;gui
GUICreate("Circle Settings", 423, 346, -1, -1, BitOR($WS_OVERLAPPEDWINDOW, $WS_CLIPSIBLINGS))
$create_file = GUICtrlCreateButton("Create File", 140, 300, 140, 30)
GUICtrlCreateLabel("FileName:", 20, 20, 50, 20)
$gui_filename = GUICtrlCreateInput($defaultfilename, 80, 20, 310, 20)
GUICtrlCreateLabel("Center Latitude", 20, 60, 80, 20)
$gui_cen_lat = GUICtrlCreateInput(37.422000, 120, 60, 270, 20)
GUICtrlCreateLabel("Center Longitude", 20, 90, 90, 20)
$gui_cen_lon = GUICtrlCreateInput(-122.084073, 120, 90, 270, 20)
GUICtrlCreateGroup("Fill out one or the other", 10, 130, 400, 160)
GUICtrlCreateLabel("Either enter coordinates of point on circumference", 30, 150, 380, 20)
GUICtrlCreateLabel("Latitude", 30, 170, 40, 20)
$gui_cir_lat = GUICtrlCreateInput("", 90, 170, 310, 20)
GUICtrlCreateLabel("Longitude", 30, 200, 50, 20)
$gui_cir_lon = GUICtrlCreateInput("", 90, 200, 310, 20)
GUICtrlCreateLabel("Or enter radius of circle (in meters)", 30, 230, 380, 20)
GUICtrlCreateLabel("radius", 30, 260, 50, 20)
$gui_rad = GUICtrlCreateInput("", 90, 260, 310, 20)

GUISetState()
While 1
	$msg = GUIGetMsg()
	Select
		Case $msg = $create_file
			$filename = GUICtrlRead($gui_filename)
			$centerlat_form = GUICtrlRead($gui_cen_lat)
			$centerlong_form = GUICtrlRead($gui_cen_lon)
			$circumlat_form = GUICtrlRead($gui_cir_lat)
			$circumlong_form = GUICtrlRead($gui_cir_lon)
			$radius_form = GUICtrlRead($gui_rad)
			;delete old file if it exists
			FileDelete($filename)
			
			; convert coordinates to radians
			$lat1 = _deg2rad($centerlat_form)
			$long1 = _deg2rad($centerlong_form)

			$lat2 = _deg2rad($circumlat_form)
			$long2 = _deg2rad($circumlong_form)
			; get the difference between lat/long coords
			$dlat = $lat2 - $lat1
			$dlong = $long2 - $long1
			; if the radius of the circle wasn't given, we need to calculate it
			If $radius_form = "" Then
				; compute distance of great circle
				$a = ((Sin($dlat / 2)) * (Sin($dlat / 2))) + Cos($lat1) * Cos($lat2) * ((Sin($dlong / 2)) * (Sin($dlong / 2))) ; origionally  a = pow((sin($dlat/2)), 2) + cos($lat1) * cos($lat2) * pow((sin($dlong/2)), 2);
				$c = 2 * ATan(Sqrt($a) / Sqrt(1 - $a)) ; origionally atan2(sqrt($a), sqrt(1-$a)) - see http://en.wikipedia.org/wiki/Atan2 - this should work as long as Sqrt(1 - $a) is greater than 0
				; get distance between points (in meters)
				$d = 6378137 * $c
			Else
				$d = $radius_form
			EndIf
			$d_rad = $d / 6378137
			;create header
			$file = '<?xml version="1.0" encoding="UTF-8"?>'  & @CRLF _
					& '<kml xmlns="http://earth.google.com/kml/2.1">' & @CRLF _
					& '<Document>' & @CRLF _
					& '<name>' & $filename & '</name>' & @CRLF _
					& '<open>1</open>' & @CRLF _
					& '<Style id="Location">' & @CRLF _
					& '<LineStyle>' & @CRLF _
					& '<color>7f0000ff</color>' & @CRLF _ 
					& '<width>2</width>' & @CRLF _
					& '</LineStyle>' & @CRLF _
					& '</Style>' & @CRLF _
					& '<Placemark>' & @CRLF _
					& '<name>Location</name>' & @CRLF _ 
					& '<styleUrl>#Location</styleUrl>' & @CRLF _
					& '<LineString>' & @CRLF _
					& '<extrude>1</extrude>' & @CRLF _
					& '<tessellate>1</tessellate>' & @CRLF _
					& '<coordinates>' & @CRLF _
					
			; loop through the array and write path linestrings
			For $i = 0 To 360
				$radial = _deg2rad($i)
				$lat_rad = ASin(Sin($lat1) * Cos($d_rad) + Cos($lat1) * Sin($d_rad) * Cos($radial))
				$dlon_rad = ATan(Sin($radial) * Sin($d_rad) * Cos($lat1)) / (Cos($d_rad) - Sin($lat1) * Sin($lat_rad))
				$lon_rad = Mod(($long1 + $dlon_rad + $PI), 2 * $PI) - $PI ; origionally fmod(($long1 + $dlon_rad + $PI), 2 * $PI) - $PI
				$file &= _rad2deg($lon_rad) & ',' & _rad2deg($lat_rad) & ',' & $viewdistance & @CRLF
			Next
			; create footer
			$file &= '</coordinates>'  & @CRLF _
					& '</LineString>'  & @CRLF _
					& '</Placemark>'  & @CRLF _
					& '</Document>'  & @CRLF _
					& '</kml>'
			; write file
			FileWrite($filename, $file)
			Exit
		Case $msg = $GUI_EVENT_CLOSE
			ExitLoop
		Case Else
			;;;
	EndSelect
WEnd
Exit


Func _deg2rad($degree) ;convert degrees to radians
	Return ($degree * ($PI / 180))
EndFunc   ;==>_deg2rad

Func _rad2deg($radian) ;convert radians to degrees
	Return ($radian * (180 / $PI))
EndFunc   ;==>_rad2deg


